/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.uddi;

import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Logger;
import java.io.StringReader;
import java.net.URL;
import java.util.Vector;
import org.apache.axis.utils.XMLUtils;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.proxy.Transport;
import org.apache.soap.Body;
import org.apache.soap.Envelope;
import org.apache.soap.SOAPException;
import org.apache.soap.messaging.Message;
import org.apache.soap.transport.SOAPTransport;
import org.apache.soap.transport.http.SOAPHTTPConnection;
import org.apache.soap.util.xml.DOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ApacheSOAPTransport
implements Transport {
    private SOAPHTTPConnection connection;
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    protected static final String m_className = "ApacheSOAPTransport";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApacheSOAPTransport() {
        String m_method = "Ctor";
        logger.entering(m_className, m_method);
        this.connection = new SOAPHTTPConnection();
        this.connection.setProxyHost(System.getProperty("http.proxyHost"));
        this.connection.setProxyUserName(System.getProperty("http.proxyUserName"));
        this.connection.setProxyPassword(System.getProperty("http.proxyPassword"));
        this.connection.setUserName(System.getProperty("http.basicAuthUserName"));
        this.connection.setPassword(System.getProperty("http.basicAuthPassword"));
        String proxyPortString = System.getProperty("http.proxyPort");
        if (proxyPortString != null) {
            try {
                this.connection.setProxyPort(new Integer(proxyPortString).intValue());
            }
            catch (Exception exception) {}
        }
    }

    public Element send(Element el, URL url) throws RegistryException {
        String m_method = "send(Element, URL)";
        logger.entering(m_className, m_method);
        Envelope sendEnv = new Envelope();
        Body sendBody = new Body();
        Vector<Element> bodyEntry = new Vector<Element>();
        bodyEntry.add(el);
        sendBody.setBodyEntries(bodyEntry);
        sendEnv.setBody(sendBody);
        Message soapMessage = new Message();
        soapMessage.setSOAPTransport((SOAPTransport)this.connection);
        Element base = null;
        try {
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "\nRequest body:\n" + DOMWriter.nodeToString((Node)el));
            }
            soapMessage.send(url, "", sendEnv);
            Envelope responseEnv = soapMessage.receiveEnvelope();
            Body responseBody = responseEnv.getBody();
            base = (Element)responseBody.getBodyEntries().firstElement();
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "\nResponse body:\n" + DOMWriter.nodeToString((Node)base));
            }
        }
        catch (SOAPException e) {
            throw new RegistryException((Exception)((Object)e));
        }
        finally {
            logger.exiting(m_className, m_method);
        }
        return base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String send(String request, URL url) throws RegistryException {
        String m_method = "send(String, URL)";
        try {
            Element response;
            Node node;
            Document doc;
            logger.entering(m_className, m_method);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "request = " + request + "\nURL= " + url);
            }
            if ((doc = ApacheSOAPTransport.xmlToDocument(request)) != null && (node = doc.getFirstChild()) != null && node instanceof Element && (response = this.send((Element)node, url)) != null) {
                String string = XMLUtils.ElementToString((Element)response);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    public static Document xmlToDocument(String xml) {
        String method = "xmlToDocument(Strng xml)";
        if (xml == null) {
            return null;
        }
        try {
            String s = null;
            int idx = xml.indexOf("<?xml");
            if (idx != -1) {
                s = xml;
            } else {
                String rootElementName = "tempRoot";
                if (xml.indexOf("<" + rootElementName + ">") == -1) {
                    s = "<" + rootElementName + ">" + xml + "</" + rootElementName + ">";
                }
            }
            Document doc = XMLHelper.parseDocumentViaDOM(new InputSource(new StringReader(s)), null, null, false, false);
            return doc;
        }
        catch (Throwable t) {
            logger.throwing(m_className, method, t);
            return null;
        }
    }
}

